#include "StdAfx.h"
#include "CLS_SdvFileReader.h"
#include "Logon.h"
#include "DeviceCtrl.h"
#include "NvsInfo.h"
#include "Include/IniFile.h"
#include "PWDChangeDlg.h"
#include "SearchNVS.h"
#include <share.h>
#include "DecCtrlClientTypes.h"
#include <process.h> 

CLS_SdvFileReader::CLS_SdvFileReader()
{
}

CLS_SdvFileReader::CLS_SdvFileReader( CString _strName )
{
	m_pFile = _fsopen((LPCSTR)(LPCTSTR)_strName,"rb", _SH_DENYNO);
	if (NULL == m_pFile)
	{
		AddLog(LOG_LEVEL_ERROR,"NULL == m_pFile");
		return;
	}
	
	fseek(m_pFile, 0, SEEK_END);
	if (ftell(m_pFile) < sizeof(S_header))
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::OnBnClickedButtonPushStream] File size less than 88.");
		fclose(m_pFile);
		return;
	}
	fseek(m_pFile, 0, SEEK_SET);	
	fread(&m_FileHeader, sizeof(char), sizeof(S_header), m_pFile);
	m_bFileHeader = TRUE;
}

CLS_SdvFileReader::~CLS_SdvFileReader(void)
{
	if (m_pFile != NULL)
	{
		fclose(m_pFile);
		m_pFile = NULL;
	}
}

int CLS_SdvFileReader::ReadFrame( char* _pReadBuffer, int _iBufferLen )
{
	if (m_pFile == NULL)
	{
		return 0;
	}

	if ((m_pFile)&&feof(m_pFile))
	{
		fseek(m_pFile, sizeof(S_header), SEEK_SET);
	}

	return fread(_pReadBuffer, sizeof(char), _iBufferLen, m_pFile);
}

